/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.data.codec.util.ExtraCodecs;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.registries.ForgeRegistries;

public record BlockRequirement(Optional<List<Either<TagKey<Block>, Block>>> blocks, Optional<StateRequirement> state, Optional<NbtRequirement> nbt, Optional<Direction> sturdyFace, Optional<Boolean> withinWorldBounds, Optional<Boolean> replaceable, boolean negate) {
    public static final BlockRequirement NONE = new BlockRequirement(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), false);
    public static final Codec<BlockRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ConfigHelper.tagOrForgeRegistryCodec(Registry.f_122901_, ForgeRegistries.BLOCKS).listOf().optionalFieldOf("blocks").forGetter(predicate -> predicate.blocks), (App)StateRequirement.CODEC.optionalFieldOf("state").forGetter(predicate -> predicate.state), (App)NbtRequirement.CODEC.optionalFieldOf("nbt").forGetter(predicate -> predicate.nbt), (App)Direction.f_175356_.optionalFieldOf("has_sturdy_face").forGetter(predicate -> predicate.sturdyFace), (App)Codec.BOOL.optionalFieldOf("within_world_bounds").forGetter(predicate -> predicate.withinWorldBounds), (App)Codec.BOOL.optionalFieldOf("replaceable").forGetter(predicate -> predicate.replaceable), (App)Codec.BOOL.optionalFieldOf("negate", (Object)false).forGetter(predicate -> predicate.negate)).apply((Applicative)instance, BlockRequirement::new));

    public boolean test(Level pLevel, BlockPos pPos) {
        if (!pLevel.m_46749_(pPos)) {
            return false;
        }
        BlockState blockstate = pLevel.m_8055_(pPos);
        if (this.blocks.isPresent() && this.blocks.get().stream().noneMatch(either -> (Boolean)either.map(arg_0 -> ((BlockState)blockstate).m_204336_(arg_0), arg_0 -> ((BlockState)blockstate).m_60713_(arg_0)))) {
            return false ^ this.negate;
        }
        if (this.state.isPresent() && !this.state.get().test(blockstate)) {
            return false ^ this.negate;
        }
        if (this.nbt.isPresent()) {
            BlockEntity blockentity = pLevel.m_7702_(pPos);
            return (blockentity != null && this.nbt.get().test((Tag)blockentity.m_187480_())) ^ this.negate;
        }
        if (this.sturdyFace.isPresent()) {
            return blockstate.m_60783_((BlockGetter)pLevel, pPos, this.sturdyFace.get()) ^ this.negate;
        }
        if (this.withinWorldBounds.isPresent()) {
            return pLevel.m_6857_().m_61937_(pPos) ^ this.negate;
        }
        if (this.replaceable.isPresent()) {
            return blockstate.m_60795_() || blockstate.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(pLevel, pPos, Direction.DOWN, ItemStack.f_41583_, Direction.UP)) ^ this.negate;
        }
        return true ^ this.negate;
    }

    public CompoundTag serialize() {
        return (CompoundTag)CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this).result().orElseGet(CompoundTag::new);
    }

    public static BlockRequirement deserialize(CompoundTag tag) {
        return (BlockRequirement)((Pair)CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)tag).result().orElseThrow(() -> new IllegalArgumentException("Could not deserialize BlockRequirement"))).getFirst();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BlockRequirement that = (BlockRequirement)obj;
        if (!this.blocks.equals(that.blocks)) {
            return false;
        }
        if (!this.state.equals(that.state)) {
            return false;
        }
        if (!this.nbt.equals(that.nbt)) {
            return false;
        }
        if (!this.sturdyFace.equals(that.sturdyFace)) {
            return false;
        }
        if (!this.withinWorldBounds.equals(that.withinWorldBounds)) {
            return false;
        }
        if (!this.replaceable.equals(that.replaceable)) {
            return false;
        }
        return this.negate == that.negate;
    }

    @Override
    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    public record StateRequirement(Map<String, Object> properties) {
        public static final Codec<StateRequirement> CODEC = Codec.unboundedMap((Codec)Codec.STRING, ExtraCodecs.anyOf(new Codec[]{Codec.BOOL, Codec.INT, Codec.STRING, IntegerBounds.CODEC})).xmap(StateRequirement::new, StateRequirement::properties);

        public CompoundTag serialize() {
            return (CompoundTag)CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this).result().orElseGet(CompoundTag::new);
        }

        public static StateRequirement deserialize(CompoundTag tag) {
            return (StateRequirement)((Pair)CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)tag).result().orElseThrow(() -> new IllegalArgumentException("Could not deserialize BlockRequirement"))).getFirst();
        }

        public boolean test(BlockState state) {
            return this.test(state.m_60734_().m_49965_(), state);
        }

        public boolean test(FluidState state) {
            return this.test(state.m_76152_().m_76144_(), state);
        }

        public <S extends StateHolder<?, S>> boolean test(StateDefinition<?, S> stateDefinition, S state) {
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                Property property = stateDefinition.m_61081_(key);
                if (property == null) {
                    return false;
                }
                if (value instanceof IntegerBounds) {
                    IntegerBounds bounds = (IntegerBounds)value;
                    if (property.m_6908_().contains(bounds.min()) && property.m_6908_().contains(bounds.max()) && bounds.test((Integer)state.m_61143_(property))) continue;
                    return false;
                }
                if (property.m_6908_().contains(value) && state.m_61143_(property).toString().equals(value.toString())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            StateRequirement that = (StateRequirement)obj;
            return this.properties.equals(that.properties);
        }
    }
}

